<?php

namespace GSPIN\ShortcodeBuilder;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class Data {

    /**
     * Returns $wpdb global variable.
     * 
     * @since  1.10.14
     */
    public function getWpdb() {
        global $wpdb;

        if ( wp_doing_ajax() ) {
            $wpdb->show_errors = false;
        }

        return $wpdb;
    }

    /**
     * Get defined database columns.
     * 
     * @since  1.10.14
     * @return array Shortcode table database columns.
     */
    public function getColumns() {
        return array(
            'shortcode_name'     => '%s',
            'shortcode_settings' => '%s',
            'userid'             => '%s',
            'board_name'         => '%s',
            'count'              => '%d',
            'show_pin_title'     => '%d'
        );
    }

    /**
     * Checks for database errors.
     * 
     * @since  1.10.14
     * @return bool true/false based on the error status.
     */
    public function error() {
        $wpdb = gsPinBuilder()->data->getWpdb();

        if ( '' === $wpdb->last_error ) {
            return false;
        }

        return true;
    }

}