<?php

namespace GSPIN;

// if direct access than exit the file.
defined( 'ABSPATH' ) || exit;

/**
 * Responsible for the plugin shortcodes.
 * 
 * @since 2.0.8
 */
class Shortcodes {

	/**
	 * Constructor of the class.
	 * 
	 * @since 2.0.8
	 */
	public function __construct() {
		add_shortcode( 'gs_pinterest', array( $this, 'pinterestShortcode' ) );
		add_shortcode( 'gs_pin_widget', array( $this, 'pinWidget' ) );
		add_shortcode( 'gs_follow_pin_widget', array( $this, 'followPinShortcodeWidget' ) );
	}

	/**
	 * Renders pinterest main shortcode.
	 * 
	 * @since 2.0.8
	 * 
	 * @param  array $atts Shortcode attributes.
	 * @return html        Output markup.
	 */
	public function pinterestShortcode( $atts ) {
		$atts            = gsPinBuilder()->manager->getShortcodeDefaultSettings( $atts );
		$gutter          = gspin()->helpers->getOption( 'gs_pins_gutter', 10 );
		$gs_pin_title    = gspin()->helpers->getOption( 'gs_pin_title', 'on' );
		$gs_pin_link_tar = gspin()->helpers->getOption( 'gs_pin_link_tar', '_blank' );

		// Build settings for the preview.
		if ( gsPinBuilder()->preview->isPreview() ) {
			$shortcode = gsPinBuilder()->manager->getTempSettings( $atts['id'] );
			$username  = $shortcode['userid'];
			$board     = $shortcode['board_name'];
			$count     = $shortcode['count'];
			$settings  = $shortcode['shortcode_settings'];
			$theme     = $settings['theme'];
			$gs_pin_title = $shortcode[ 'show_pin_title' ];
		} else {
			// Build settings if it's from shortcode builder.
			if ( gspin()->helpers->isFromShortcodeBuilder( $atts ) ) {
				$shortcode = gsPinBuilder()->manager->getShortcodeById( $atts[ 'id' ], false );

				$username = $shortcode ? $shortcode['userid'] : '';
				$board    = $shortcode ? $shortcode['board_name'] : '';
				$count    = $shortcode ? $shortcode['count'] : '';
				$settings = $shortcode ? $shortcode['shortcode_settings'] : '';
				$theme    = $shortcode ? $settings['theme'] : '';
				$gs_pin_title = $shortcode ? $shortcode[ 'show_pin_title' ] : '';
			} else {
				// Build settings for the regular shortcode.
				$username =	$atts['user'];
				$board    = $atts['board'];
				$count    = $atts['count'];
				$theme    = $atts['theme'];
			}
		}

		// responsive
		$desktop         = ! empty( $settings['columns'] ) ? $settings['columns'] : 3;
		$tablet          = ! empty( $settings['columns_tablet'] ) ? $settings['columns_tablet'] : 2;
		$mobile_portrait = ! empty( $settings['columns_mobile_portrait'] ) ? $settings['columns_mobile_portrait'] : 2;
		$columns_mobile  = ! empty( $settings['columns_mobile'] ) ? $settings['columns_mobile'] : 1;
		$columnClasses   = gspin()->helpers->getColumnClasses( $desktop, $tablet, $mobile_portrait, $columns_mobile );

		$feedUrl     = gspin()->helpers->buildUrl( $username, $board );
		$gs_rss_pins = gspin()->helpers->fetchPins( $feedUrl, $count );
		$folder      = GSPIN_PLUGIN_DIR . 'includes/templates/';
		$output      = '';
		$output .= sprintf( '<div class="gs_pin_area %s" data-gutter="%s">', $theme, $gutter );

		if ( ! is_array( $gs_rss_pins ) ) {
			return;
		}
		
		if ( 'gs_pin_theme1' === $theme ) {
			$file = 'gs_pinterest_structure_one.php';
		}

		if ( gspin()->helpers->isProActive() && 'gs_pin_theme1' !== $theme ) {
			$folder  = GSPIN_PRO_PLUGIN_DIR . 'templates/';

			if ( 'gs_pin_theme2' === $theme ) {
				$file = 'gs_pinterest_structure_two.php';
			}

			if ( 'gs_pin_theme3' === $theme ) {
				$file = 'gs_pinterest_structure_three_hov.php';
			}

			if ( 'gs_pin_theme4' === $theme ) {
				$file = 'gs_pinterest_structure_four_pop.php';
			}

			if ( 'gs_pin_theme5' === $theme ) {
				$file = 'gs_pinterest_structure_five_grey.php';
			}
		}

		if ( ! empty( $file ) ) {
			$file = $folder . $file;
			if ( file_exists( $file ) ) {
				include( $file );
			}
		}
		$output .= gspin()->helpers->generateStyles( $gutter );
		$output .= gspin()->helpers->generateScripts();
		$output .= '</div>';
		return $output;
	}

	/**
	 * Pin widget shortcode.
	 * 
	 * @since 2.0.8
	 * 
	 * @param  array $atts Shortcode attributes.
	 * @return html        Output markup.
	 */
	public function pinWidget( $atts ) {
		$atts = shortcode_atts(
			array(
				'pin_link'  => '',
				'pin_width' => ''
			),
			$atts 
		);

		$output = '';
		$output .= '<div class="pin-widget-area">';
			$output .= '<a data-pin-do="embedPin" data-pin-width="'. $atts['pin_width'] .'" href="'. $atts['pin_link'] .'"></a>';
		$output .= '</div>';
		return $output;
	}

	/**
	 * Follow Pin widget shortcode.
	 * 
	 * @since 2.0.8
	 * 
	 * @param  array $atts Shortcode attributes.
	 * @return html        Output markup.
	 */
	public function followPinShortcodeWidget( $atts ) {
		$atts = shortcode_atts(
			array(
				'pin_user'     => '',
				'follow_lebel' => ''
			),
			$atts
		);

		$output = '';
		$output .= '<div class="pin-follow-widget-area">';
			$output .= sprintf(
				'<a data-pin-do="buttonFollow" href="https://www.pinterest.com/%s/">%s</a>',
				$atts['pin_user'], $atts['follow_lebel']
			);
		$output .= '</div>';
		return $output;
	}
}