<?php

namespace GSPIN\Settings;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class SettingsConfig {

    private $settings_api;

    public function __construct() {
        $this->settings_api = new \GSPIN\Settings\SettingsApi;
        
        $this->themeOptions = apply_filters(
            'gspin_theme_options',
            array(
                'gs_pin_theme1'   => 'Theme 1 (Pins)'
            )
    );
    }

    public function get_settings_sections() {
        $sections = array(
            array(
                'id' 	=> 'gs_pinterest_settings',
                'title' => __( 'GS Pinterest Settings', 'gs-pinterest' )
            )
        );
        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    public function get_settings_fields() {
        $settings_fields = array(
            'gs_pinterest_settings' => array(
                // User
                array(
                    'name'      => 'gs_pin_user',
                    'label'     => __( 'Pinterest User', 'gs-pinterest' ),
                    'desc'      => __( 'Enter Pinterest username', 'gs-pinterest' ),
                    'type'      => 'text',
                    'default'   => ''
                ),
                // Board
                array(
                    'name'      => 'gs_pin_board',
                    'label'     => __( 'Pinterest Board Name', 'gs-pinterest' ),
                    'desc'      => __( 'Enter Pinterest Board name for Specific board pins', 'gs-pinterest' ),
                    'type'      => 'text',
                    'default'   => ''
                ),
                 // Number of pins to display
                array(
                    'name'  => 'gs_tot_pins',
                    'label' => __( 'Total Pins to display', 'gs-pinterest' ),
                    'desc'  => __( 'Set number of pins to display. Default 10, max 25', 'gs-pinterest' ),
                    'type'  => 'number',
                    'min'   => 1,
                    'max'   => 25,
                    'default' => 10
                ),
                // theme
                array(
                    'name'  => 'gs_pin_theme',
                    'label' => __( 'Style & Theming', 'gs-pinterest' ),
                    'desc'  => __( 'Select preferred Style & Theme', 'gs-pinterest' ),
                    'type'  => 'select',
                    'default'   => 'gs_pin_theme1',
                    'options'   => $this->themeOptions
                ),
                // Pins Link Target
                array(
                    'name'      => 'gs_pin_link_tar',
                    'label'     => __( 'Pins Link Target', 'gs-pinterest' ),
                    'desc'      => __( 'Specify target to load the Links, Default New Tab ', 'gs-pinterest' ),
                    'type'      => 'select',
                    'default'   => '_blank',
                    'options'   => array(
                        '_blank'    => 'New Tab',
                        '_self'     => 'Same Window'
                    )
                ),
                // Pin Title
                array(
                    'name'      => 'gs_pin_title',
                    'label'     => __( 'Pin Title', 'gs-pinterest' ),
                    'desc'      => __( 'Show or Hide Pin Title', 'gs-pinterest' ),
                    'type'      => 'switch',
                    'switch_default' => 'ON'
                ),
                // column
                array(
                    'name'  => 'gs_pins_col',
                    'label' => __( 'Pins Column', 'gs-pinterest' ),
                    'desc'  => __( 'Number of column/s to display pins', 'gs-pinterest' ),
                    'type'  => 'select',
                    'default'   => '25',
                    'options'   => array(
                        '33.33' => '3 Columns',
                        '25'    => '4 Columns',
                        '20'    => '5 Columns - PRO',
                        '16.66' => '6 Columns - PRO'
                    )
                ),
                // Gutter
                array(
                    'name'  => 'gs_pins_gutter',
                    'label' => __( 'Gutter', 'gs-pinterest' ),
                    'desc'  => __( 'Set Gutter width, Default 10', 'gs-pinterest' ),
                    'type'  => 'number',
                    'min'   => 0,
                    'max'   => 20,
                    'default' => 10
                ),

                // Pinterest Custom CSS
                array(
                    'name'    => 'gs_pin_custom_css',
                    'label'   => __( 'Pinterest Custom CSS', 'gs-pinterest' ),
                    'desc'    => __( 'You can write your own custom css', 'gs-pinterest' ),
                    'type'    => 'textarea'
                )    
            )
        );

        return $settings_fields;
    }


    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    public function get_pages() {
        $pages = get_pages();
        $pages_options = array();
        if ( $pages ) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }

        return $pages_options;
    }

}