<?php

if (!class_exists('UpiCRMAffiliate')) {

    class UpiCRMAffiliate {

        var $wpdb;

        public function __construct() {
            global $wpdb;
            $this->wpdb = &$wpdb;
        }

        function show_leads_table_load_script() {
            wp_register_script('upicrm_affiliate_datatables', 'https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js', array('jquery'), '1.0');
            wp_register_script('upicrm_affiliate_datatables_responsive', 'https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js', array('jquery'), '1.0');

            wp_register_style('upicrm_affiliate_datatables_style', 'https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css', FALSE, '0.1');
            wp_register_style('upicrm_affiliate_datatables_responsive_style', 'https://cdn.datatables.net/responsive/2.2.5/css/responsive.dataTables.min.css', FALSE, '0.1');
        }

        function show_leads_table($atts, $content) {

            ob_start();

            $UpiCRMLeads = new UpiCRMLeads();
            $UpiCRMUsers = new UpiCRMUsers();
            $UpiCRMLeads = new UpiCRMLeads();
            $UpiCRMFields = new UpiCRMFields();
            $UpiCRMUIBuilder = new UpiCRMUIBuilder();
            $UpiCRMFieldsMapping = new UpiCRMFieldsMapping();
            $UpiCRMLeadsStatus = new UpiCRMLeadsStatus();

            wp_enqueue_style('upicrm_affiliate_datatables_style');
            wp_enqueue_style('upicrm_affiliate_datatables_responsive_style');
            $wp_scripts = wp_scripts();
            wp_enqueue_style('plugin_name-admin-ui-css',
                    'http://ajax.googleapis.com/ajax/libs/jqueryui/' . $wp_scripts->registered['jquery-ui-core']->ver . '/themes/smoothness/jquery-ui.css',
                    false,
                    1.0,
                    false);

            wp_enqueue_script('upicrm_affiliate_datatables');
            wp_enqueue_script('upicrm_affiliate_datatables_responsive');
            wp_enqueue_script('jquery-ui-datepicker');


            /* if (!is_rtl()) {
              echo '
              <style>div.dataTables_wrapper {
              direction: rtl;
              }
              </style>';
              echo get_locale();
              http://cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/
              } */

            $langArr = upicrm_get_lang_arr();
            $lang = $langArr[get_locale()];

            $err = false;
            if ($UpiCRMUsers->get_permission()) {
                $field_on = @get_option('upicrm_affiliate_show_fields');
                if (!$field_on) {
                    $err = true;
                }
                $list_option = $UpiCRMUIBuilder->get_list_option();
                if (!$list_option) {
                    $err = true;
                }
                $getNamesMap = $UpiCRMFieldsMapping->get();
                if (isset($atts['filter_by']) && $atts['filter_by'] = 'assigned_to') {
                    $getLeads = $UpiCRMLeads->get(get_current_user_id(), 0, 0, 'DESC', 0, 0, 0, 0);
                } else {
                    $getLeads = $UpiCRMLeads->get(0, 0, 0, 'DESC', 0, 0, 0, get_current_user_id());
                }
                $UpiCRMLeadsStatus = new UpiCRMLeadsStatus();
                $status_ARR = $UpiCRMLeadsStatus->get_as_array();

                
                if (isset($atts['show']) && isset($atts['field'])) {
                    if (@count($getLeads) > 0) {
                        foreach ($getLeads as $num => $leadObj) {
                            $checkDate = $UpiCRMUIBuilder->lead_routing($leadObj, 'content', $atts['field'], $getNamesMap, true, true);
                            $startMonth = date('Y-m-d', strtotime("first day of this month"));
                            $endMonth = date('Y-m-d', strtotime("last day of this month"));

                            $checkDate = $checkDate ? $checkDate : date('Y-m-d');

                            if (($checkDate >= $startMonth) && ($checkDate <= $endMonth)) {
                                if (strtolower($atts['show']) == "no_month") {
                                    unset($getLeads[$num]);
                                }
                            } else {
                                if (strtolower($atts['show']) == "month") {
                                    unset($getLeads[$num]);
                                }
                            }
                        }
                    }
                }
                
                if (isset($atts['from_month']) && isset($atts['to_month']) && isset($atts['field'])) {
                    if (@count($getLeads) > 0) {
                        foreach ($getLeads as $num => $leadObj) {
                            $checkDate = $UpiCRMUIBuilder->lead_routing($leadObj, 'content', $atts['field'], $getNamesMap, true, true);


                            $startMonth = date('Y-m-01', strtotime(date('Y-m-d')." -{$atts['from_month']} month")); //strtotime("first day of this month")
                            $endMonth = date('Y-m-t', strtotime(date('Y-m-d')." +{$atts['to_month']} month"));


                            $checkDate = $checkDate ? $checkDate : date('Y-m-d');

                            if (($checkDate <= $startMonth) || ($checkDate >= $endMonth)) {
                                unset($getLeads[$num]);
                            }
                        }
                    }
                }
                
                if (isset($atts['status'])) {
                    if (@count($getLeads) > 0) {
                        
                        foreach ($getLeads as $num => $leadObj) {
                            if (upicrm_string_cleaner($atts['status']) != upicrm_string_cleaner($status_ARR[$leadObj->lead_status_id]) ) {
                                unset($getLeads[$num]);
                            }
                        }
                    }
                }
                if (!$getLeads) {
                    $err = true;
                }
            } else {
                $err = true;
            }

            if (!$err) {
                include @get_upicrm_template_path('affiliates_table_shortcode');
            } else {
                _e('No leads to show', 'upicrm');
            }

            return ob_get_clean();
        }

        function show_leads_edit() {

            ob_start();
            $UpiCRMUIBuilder = new UpiCRMUIBuilder();
            $UpiCRMFieldsMapping = new UpiCRMFieldsMapping();
            $UpiCRMLeads = new UpiCRMLeads();
            $UpiCRMFields = new UpiCRMFields();
            $UpiCRMIntegrations = new UpiCRMIntegrations();
            $UpiCRMLeadsChangesLog = new UpiCRMLeadsChangesLog();
            
            $lead_id = (int)$_GET['lead_id'];
            if ($this->user_has_access($lead_id)) {
                
                if ($_POST['action'] == "edit_aff") {
                    
                    $lead_id = (int)$_POST['lead_id'];
                    
                    foreach ($_POST['content'] as $key => $value) {
                        $lead_content_arr[str_replace("_", " ", $key)] = $value;
                    }
                    
                    $updateArr['lead_content'] = json_encode($lead_content_arr);
                    
                    $UpiCRMLeads->change_status((int)$_POST['lead_status_id'],$lead_id);
                    
                    if (isset($_POST['lead_remarks'])) {
                        $updateArr['lead_management_comment'] = $_POST['lead_remarks'];
                    }
                    
                    $UpiCRMLeads->update_by_id($lead_id, $updateArr);
                    
                    $log = [
                        'lead_id' => $lead_id,
                        'lead_change_log_edit_text' => $lead_content_arr,
                    ];
                    $UpiCRMLeadsChangesLog->add($log);
                    
  
                }
                
                $leadObj = $UpiCRMLeads->get_by_id($lead_id);
                $list_option = $UpiCRMUIBuilder->get_list_option();
                $getNamesMap = $UpiCRMFieldsMapping->get();
                $field_on = @get_option('upicrm_affiliate_show_fields');

                /*if ($lead->source_type == $SourceTypeID['upi_integration']) {
                    $is_integration = true;
                    $fields = $UpiCRMFields->get(); 
                    foreach ($fields as $field) {
                        $list_option[$field->field_name] = $field->field_name;
                    }
                }
                else {
                    $is_integration = false;
                    $getNamesMap = $UpiCRMFieldsMapping->get_all_by($lead->source_id, $lead->source_type);
                    foreach ($UpiCRMFields->get() as $field) { 
                        foreach ($getNamesMap as $map) {
                            if ($map->field_id == $field->field_id) {
                                //var_dump($field);
                                $list_option[$field->field_id] = $field->field_name;  
                            }
                        }
                    }
                }*/
                
   
                include @get_upicrm_template_path('affiliates_edit_shortcode');
            }



            return ob_get_clean();
        }
        
        
        function show_leads_count($atts) {
            ob_start();
            $table_name = 'upicrm_affiliate_table_'.$atts['id'];
            ?>
            <span id="count_<?=$table_name;?>"></span>

            <?php
            return ob_get_clean();
        }
        
        function show_export() {
            
            $UpiCRMFields = new UpiCRMFields();
            $UpiCRMUIBuilder = new UpiCRMUIBuilder();
            $list_option = $UpiCRMUIBuilder->get_list_option();

            include @get_upicrm_template_path('affiliates_export_shortcode');
            return ob_get_clean();
            ob_start();
        }

        function affiliate_time_save() {
            $this->wpdb->update(upicrm_db() . "leads", array("affiliate_time" => $_POST['affiliate_time']), array("lead_id" => (int) $_POST['lead_id']));
            //print_r($_POST);
            echo 1;
            die();
        }
        
        function upicrm_export_do() {
            $export_fields = false;
            if (isset($_POST['export_fields']) && count($_POST['export_fields']) > 0) {
                foreach ($_POST['export_fields'] as $export) {
                    $explode = explode("||exp||",$export);
                    $export_fields[$explode[0]][$explode[1]] = 1;
                }
            }
            upicrm_export_csv(true,true,$export_fields);
            die();
        }

        function get_users() {
            $get_users = get_users(array('role' => '')); //Editor, Administrator
            $arr = [];
            foreach ($get_users as $user) {
                if (get_the_author_meta('upicrm_user_permission', $user->ID) == 3) {
                    $arr[$user->ID] = $user;
                }
            }
            return $arr;
        }

        function get_childrens_by_parent_id($affiliate_id) {
            $users = get_users(array('role' => '')); //Editor, Administrator
            if ($users) {
                foreach ($users as $user) {
                    if ($affiliate_id == get_user_meta($user->ID, 'affiliate_parent_id', 1)) {
                        $arr[] = $user;
                        $get_users = $this->get_childrens_by_parent_id($user->ID);
                        if ($get_users) {
                            foreach ($get_users as $get) {
                                $arr[] = $get;
                            }
                        }
                    }
                }
            }
            return $arr;
        }

        function user_has_access($lead_id) {
            if (get_current_user_id()) {
                $UpiCRMLeads = new UpiCRMLeads();
                $leadObj = $UpiCRMLeads->get_by_id($lead_id);
                if ($leadObj->affiliate_id == get_current_user_id()) {
                    return true;
                }
                if ($leadObj->user_id == get_current_user_id()) {
                    return true;
                }
                else {
                    $users = $this->get_childrens_by_parent_id(get_current_user_id());
                    if ($users) {
                        foreach ($users as $user) {
                            if ($user->data->ID == $leadObj->affiliate_id) {
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }
        
        function get_type_arr() {
            return [
              0 => __('External', 'upicrm'),
              1 => __('Internal', 'upicrm'),  
              2 => __('Not Associated', 'upicrm'),  
            ];
        }
    }
   
}

add_shortcode('upicrm_affiliate', array(new UpiCRMAffiliate, 'show_leads_table'));
add_shortcode('upicrm_affiliate_edit', array(new UpiCRMAffiliate, 'show_leads_edit'));
add_shortcode('upicrm_affiliate_count', array(new UpiCRMAffiliate, 'show_leads_count'));
add_shortcode('upicrm_affiliate_export', array(new UpiCRMAffiliate, 'show_export'));


add_action('wp_enqueue_scripts', array(new UpiCRMAffiliate, 'show_leads_table_load_script'));
add_action('wp_ajax_affiliate_time_save', array(new UpiCRMAffiliate, 'affiliate_time_save'));
add_action('wp_ajax_nopriv_affiliate_time_save', array(new UpiCRMAffiliate, 'affiliate_time_save'));
add_action('wp_ajax_upicrm_export_do', array(new UpiCRMAffiliate, 'upicrm_export_do'));



