<?php

namespace GSPIN\ShortcodeBuilder {

    // if direct access than exit the file.
    defined('ABSPATH') || exit;

    class Builder {

        /**
         * Holds the instance of the plugin currently in use.
         *
         * @since 2.0.12
         *
         * @var GSPIN\ShortcodeBuilder\Builder
         */
        private static $instance = null;

        /**
         * Main Plugin Instance.
         *
         * Insures that only one instance of the addon exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since  2.0.12
         * @return Builder
         */
        public static function get_instance() {
            if ( ! self::$instance ) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Constructor of the class.
         * 
         * @since 2.0.12
         */
        public function __construct() {
            add_action( 'admin_enqueue_scripts', array( $this, 'adminScripts' ) );
            add_action( 'in_admin_header', array( $this, 'remove_admin_notices' ) );

            $this->manager     = new Manager;
            $this->options     = new Options;
            $this->preferences = new Preferences;
            $this->data        = new Data;
            $this->strings     = new Strings;
            $this->preview     = new Preview;
        }

        /**
         * Removed all admin notices from the shortcode builder page.
         * 
         * @since 1.4.2
         */
        public function remove_admin_notices( $hook ) {
            if ( isset( $_GET['page'] ) && 'gsp-pinterest-main' === $_GET['page'] ) {
                remove_all_actions( 'network_admin_notices' );
                remove_all_actions( 'user_admin_notices' );
                remove_all_actions( 'admin_notices' );
                remove_all_actions( 'all_admin_notices' );
            }
        }

        /**
         * Enqueue admin scripts.
         * 
         * @since  2.0.12
         * @return void
         */
        public function adminScripts( $hook ) {

            if ( 'toplevel_page_gsp-pinterest-main' != $hook ) {
                return;
            }

            wp_register_style(
                'gs-zmdi-fonts',
                GSPIN_PLUGIN_URI . '/ShortcodeBuilder/src/assets/libs/material-design-iconic-font/css/material-design-iconic-font.min.css',
                '', GSPIN_VERSION, 'all'
            );

            wp_enqueue_style(
                'gs-pinterest-builder-shortcode',
                GSPIN_PLUGIN_URI . '/ShortcodeBuilder/src/assets/css/gspin-shortcode.min.css',
                array( 'gs-zmdi-fonts' ), GSPIN_VERSION, 'all'
            );

            $data = array(
                'nonce' => array(
                    'create_shortcode' 		        => wp_create_nonce( '_gspin_create_shortcode_gs_' ),
                    'clone_shortcode' 		        => wp_create_nonce( '_gspin_clone_shortcode_gs_' ),
                    'update_shortcode' 	            => wp_create_nonce( '_gspin_update_shortcode_gs_' ),
                    'delete_shortcodes' 	        => wp_create_nonce( '_gspin_delete_shortcodes_gs_' ),
                    'temp_save_shortcode_settings' 	=> wp_create_nonce( '_gspin_temp_save_shortcode_settings_gs_' ),
                    'save_shortcode_pref' 	        => wp_create_nonce( '_gspin_save_shortcode_pref_gs_' ),
                    'sync_data' 	                => wp_create_nonce( '_gspin_sync_data_gs_' ),
                ),
                'ajaxurl'  => admin_url( 'admin-ajax.php' ),
                'adminurl' => admin_url(),
                'siteurl'  => home_url()
            );
            $data['shortcode_settings'] = gsPinBuilder()->manager->getShortcodeDefaultSettings();
            $data['shortcode_options']  = gsPinBuilder()->options->getDefaults();
            $data['translations']       = gsPinBuilder()->strings->getStrings();
            $data['preference']         = gsPinBuilder()->preferences->getDefaults();
            $data['preference_options'] = gsPinBuilder()->preferences->getShortcodePreferenceOptions();

            wp_enqueue_script(
                'gs-pinterest-shortcode',
                GSPIN_PLUGIN_URI . '/ShortcodeBuilder/src/assets/js/gspin-shortcode.min.js',
                array( 'jquery' ), GSPIN_VERSION, true
            );

            wp_localize_script( 'gs-pinterest-shortcode', 'GS_PINTEREST_DATA', $data );
        }

    }
}