<?php

namespace GSPIN\ShortcodeBuilder;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class Preview {

    /**
     * Constructor of the class.
     * 
     * @since 2.0.12
     */
    public function __construct() {
        add_action( 'wp_enqueue_scripts', array( $this, 'scripts' ) );
        add_action( 'template_include', array( $this, 'display' ) );
        add_action( 'show_admin_bar', array( $this, 'hideAdminbar' ) );
    }

    /**
     * Enqueue scripts for the preview only.
     * 
     * @since  2.0.12
     * @return void
     */
    public function scripts( $hook ) {
        if ( ! gsPinBuilder()->preview->isPreview() ) {
            return;
        }

        wp_enqueue_style(
            'gs-pinterest-shortcode-preview',
            GSPIN_PLUGIN_URI . '/ShortcodeBuilder/src/assets/css/gspin-shortcode-preview.min.css',
            '', GSPIN_VERSION, 'all'
        );
    }

    /**
     * Displays the shortcode preview.
     * 
     * @since  2.0.12
     * @return void
     */
    public function display( $template ) {
        global $wp, $wp_query;
        
        if ( gsPinBuilder()->preview->isPreview() ) {
            // Create our fake post
            $post_id              = rand( 1, 99999 ) - 9999999;
            $post                 = new \stdClass();
            $post->ID             = $post_id;
            $post->post_author    = 1;
            $post->post_date      = current_time( 'mysql' );
            $post->post_date_gmt  = current_time( 'mysql', 1 );
            $post->post_title     = __( 'Shortcode Preview', 'gs-pinterest' );
            $post->post_content   = '[gs_pinterest preview="yes" id="'.$_REQUEST['gspin_shortcode_preview'].'"]';
            $post->post_status    = 'publish';
            $post->comment_status = 'closed';
            $post->ping_status    = 'closed';
            $post->post_name      = 'fake-page-' . rand( 1, 99999 ); // append random number to avoid clash
            $post->post_type      = 'page';
            $post->filter         = 'raw'; // important!

            // Convert to WP_Post object
            $wp_post = new \WP_Post( $post );

            // Add the fake post to the cache
            wp_cache_add( $post_id, $wp_post, 'posts' );

            // Update the main query
            $wp_query->post                 = $wp_post;
            $wp_query->posts                = array( $wp_post );
            $wp_query->queried_object       = $wp_post;
            $wp_query->queried_object_id    = $post_id;
            $wp_query->found_posts          = 1;
            $wp_query->post_count           = 1;
            $wp_query->max_num_pages        = 1; 
            $wp_query->is_page              = true;
            $wp_query->is_singular          = true; 
            $wp_query->is_single            = false; 
            $wp_query->is_attachment        = false;
            $wp_query->is_archive           = false; 
            $wp_query->is_category          = false;
            $wp_query->is_tag               = false; 
            $wp_query->is_tax               = false;
            $wp_query->is_author            = false;
            $wp_query->is_date              = false;
            $wp_query->is_year              = false;
            $wp_query->is_month             = false;
            $wp_query->is_day               = false;
            $wp_query->is_time              = false;
            $wp_query->is_search            = false;
            $wp_query->is_feed              = false;
            $wp_query->is_comment_feed      = false;
            $wp_query->is_trackback         = false;
            $wp_query->is_home              = false;
            $wp_query->is_embed             = false;
            $wp_query->is_404               = false; 
            $wp_query->is_paged             = false;
            $wp_query->is_admin             = false;
            $wp_query->is_preview           = false; 
            $wp_query->is_robots            = false; 
            $wp_query->is_posts_page        = false;
            $wp_query->is_post_type_archive = false;

            // Update globals
            $GLOBALS['wp_query'] = $wp_query;
            $wp->register_globals();

            include GSPIN_PLUGIN_DIR . 'ShortcodeBuilder/gs_behance_shortcode_builder_preview.php';

            return;
        }

        return $template;
    }

    /**
     * Checks for the preview.
     * 
     * @since  2.0.12
     * @return bool
     */
    public function isPreview() {
        return isset( $_REQUEST['gspin_shortcode_preview'] ) && ! empty( $_REQUEST['gspin_shortcode_preview'] );
    }

    /**
     * Hide admin bar from the preview window.
     * 
     * @since  2.0.12
     * @return bool
     */
    public function hideAdminbar( $visibility ) {
        if ( gsPinBuilder()->preview->isPreview() ) {
            return false;
        }

        return $visibility;
    }
}