<?php
namespace GSPIN\Addons;

// if direct access than exit the file.
defined('ABSPATH') || exit;

/**
 * GS Behance WPBackery Widget
 * 
 * @since 2.0.12
 */
class WPBackery {

     // Constructor of the class.
    public function __construct() {
        add_action( 'vc_before_init', [ $this, 'integrateWithVC' ] );
    }

    /**
     * Controls for visual composer widget.
     * 
     * @since 2.0.12
     */
    public function integrateWithVC() {

        vc_map( array(
            'name'                    => __( 'GS Pinterest Portfolio ', 'gs-pinterest' ),
            'base'                    => 'gs_pinterest',
            'show_settings_on_create' => true,
            'icon'                    => GSPIN_PLUGIN_URI . '/assets/img/icon-128x128.png',
            'category'                => __( 'Content', 'gs-pinterest' ),
            'description'             => __( 'Best Responsive Pinterest plugin .', 'gs-pinterest' ),
            'params'                  => array(
                array(
                    'type'       => 'dropdown',
                    'heading'    => __( 'Shortcodes', "gs-pinterest" ),
                    'param_name' => 'id',
                    'value'      => gspin()->helpers->getVcShortcodeOptions()
                ),
            ),
        ) );
    }
}